'
'
'   [ BMModule.BAS ]
'
'     BMP,  .   FB .
'        (!).
'
'   > Quiet Snow <  2025
'   : FBC 0.23.0
'                  FBC 1.10.1
'

 #IFNDEF __FB_LINUX__
   #DEFINE BMPASM        '    . FB   ASM 
                         '   Linux - ASM   
 #ENDIF

 NAMESPACE BMP
 
 '      

 DECLARE SUB       Load  (FName AS STRING)
 DECLARE FUNCTION  ToGfxImg () AS BYTE PTR
 DECLARE FUNCTION  LoadToGfx (FName AS STRING) AS ANY PTR
 DECLARE FUNCTION  CheckerToGfx (ChSizeX AS INTEGER, ChSizeY AS INTEGER) AS ANY PTR
 'DECLARE SUB      Save  (FName AS STRING)         '    
   #IFNDEF BMPASM
 DECLARE SUB       TakePixClip (x AS ULONG, y AS ULONG)
   #ELSE
 DECLARE SUB       TakePixClip NAKED (x AS ULONG, y AS ULONG)
   #ENDIF
 DECLARE SUB       TakePix (x AS INTEGER, y AS INTEGER)
 DECLARE FUNCTION  TakePointer () AS ANY PTR
 DECLARE SUB       ClosePic ()

 '    

 DECLARE SUB       CalcMask (BYREF TheMask AS ULONG, BYREF MaskPosit AS INTEGER, BYREF MaskShift AS INTEGER, MaxShift AS INTEGER)
 DECLARE SUB       DetectType  (FName AS STRING)
 DECLARE SUB       ComputeAdressing ()
 DECLARE SUB       CnvLine (InpAdrs AS BYTE PTR, OutAdrs AS BYTE PTR)

 '    ID  *.BMP
 TYPE BMOne   FIELD = 1
   BmID     AS SHORT = 19778
   FileSize AS ULONG
   Reserved AS LONG
   BmOFFSET AS ULONG = 54
 END TYPE

 '    Info  *.BMP
 TYPE BMTwo   FIELD = 1
   HeadSize AS ULONG = 40
   BmpSizeX AS ULONG
   BmpSizeY AS ULONG
   BmSlices AS USHORT = 1
   BitDepth AS USHORT = 32
   Compress AS LONG
   DataSize AS ULONG
   BmHorRes AS ULONG
   BmVerRes AS ULONG
   UseColor AS ULONG
   SignColr AS ULONG
 END TYPE

 '      ( 16 / 32 )
 TYPE BMMsk   FIELD = 1
   RedM      AS ULONG
   GrnM      AS ULONG
   BluM      AS ULONG
   AlfM      AS ULONG
 END TYPE

 '  
   DIM  Head1 AS BMOne, Head2 AS BMTwo, BMask AS BMMsk

 '   

   DIM RAWMem     AS BYTE PTR                  '        BMP  
   DIM BMPMem     AS BYTE PTR                  '        32  
   DIM Adr        AS BYTE PTR                  '    
   DIM Adr2       AS BYTE PTR                  '    
 
   DIM BMFLn      AS UINTEGER                  '     
   DIM DTLen      AS UINTEGER                  '     
   
   DIM BMLoaded   AS BYTE                      '     ,    BMP   

   DIM BMSzX      AS ULONG                     '     
   DIM BMSzY      AS ULONG

   DIM YMuls()    AS BYTE PTR                  '       GetPix
   DIM YRevMuls() AS BYTE PTR                  '       GetPix (  Y)

   DIM YInAdrs()  AS BYTE PTR                  '       
   DIM TableAdress AS ANY PTR

   DIM BmPitch    AS INTEGER                   '        

   DIM UseMask    AS BYTE                      '     -    
   DIM UseRLE     AS BYTE                      '     -    RLE 
   DIM UseAlpha   AS BYTE                      '     -     

   DIM PixCV AS ULONG                          '     GetPix-  

   DIM PalR(255)  AS ULONG                     '      256  BMP
   DIM PalG(255)  AS ULONG
   DIM PalB(255)  AS ULONG
   DIM PalA(255)  AS ULONG
   DIM Cv256(255) AS ULONG                     '        

   DIM Cv1Bit(1) AS ULONG = {&HFF000000, -1}   '    1   --> 32  " "
   DIM Cv16Bit(65535) AS ULONG                 '    16  --> 32  " " 
   DIM CvAlf(255) AS ULONG                     '    .   BMP    

   DIM  RPosit AS INTEGER, GPosit AS INTEGER   '     
   DIM  BPosit AS INTEGER, APosit AS INTEGER
   DIM  RShift AS INTEGER, GShift AS INTEGER   '     
   DIM  BShift AS INTEGER, AShift AS INTEGER
   DIM  MaskR AS ULONG, MaskG AS ULONG         '     
   DIM  MaskB AS ULONG, MaskA AS ULONG

 '   BMP  ()
 '_____________________________________________________________
 '     0 -  
 '
 '     1 - 1 bit,   2 - 4 bit,   3 - 8 bit,   4 - 16 bit (std)
 '     5 - 16 bit + Mask     6 - 24 bit       7 - 32 bit (std)
 '     8 - 32 bit + Mask
 '
 '     9 - 4 Bit RLE         
 '    10 - 8 Bit RLE         
 '_____________________________________________________________

   DIM  BMPType AS UBYTE
 '_____________________________________________________________


 SUB CalcMask (BYREF TheMask AS ULONG, BYREF MaskPosit AS INTEGER, BYREF MaskShift AS INTEGER, MaxShift AS INTEGER)
    DIM MaskTmp AS ULONG
      '        
      FOR i AS INTEGER = 0 TO 15
         IF ((TheMask AND 1) = 1) THEN
           MaskPosit = i: EXIT FOR
         ELSE
           TheMask = TheMask SHR 1            
         END IF
      NEXT
      '             
      MaskTmp = TheMask
      FOR i AS INTEGER = 0 TO MaxShift       '     n 
         IF ((MaskTmp AND 128) = 128) THEN   '    
           MaskShift = i: EXIT FOR
         ELSE
           MaskTmp = MaskTmp SHL 1            
         END IF
      NEXT
 END SUB


 SUB CalcMask32 (BYREF TheMask AS ULONG, BYREF MaskPosit AS INTEGER)
      '        
      FOR i AS INTEGER = 0 TO 3
         IF ((TheMask AND 255) = 255) THEN
           MaskPosit = i: EXIT FOR
         END IF
         TheMask = TheMask SHR 8
      NEXT
 END SUB

' 
'       BMP
'
 SUB DetectType (FName AS STRING)

  DIM  FrF AS INTEGER
  DIM  BMError AS BYTE
  
  DIM  MaxColors AS USHORT, GetByte AS UBYTE
  DIM  R16 AS ULONG, G16 AS ULONG, B16 AS ULONG, A16 AS ULONG


  '     ,   
   IF BMLoaded THEN ClosePic ()

  '    
   FrF = FREEFILE
   IF OPEN(FName, FOR BINARY, ACCESS READ, AS #FrF) THEN EXIT SUB

  '     
   BMFLn = LOF(FrF)
   IF BMFLn = 0 OR BMFLn < 55 THEN CLOSE FrF : EXIT SUB      '     - 

  '    
   GET #FrF, , Head1

  '      BMP - 
   IF Head1.BmID <> 19778 THEN CLOSE FrF : EXIT SUB

  '     ( 40  )
   GET #FrF, , Head2
   
  '     
   BMSzX = Head2.BmpSizeX :   BMSzY = Head2.BmpSizeY

  '     
  '     -  
   IF (BMSzX = 0) OR ( BMSzY = 0) THEN CLOSE FrF : EXIT SUB

  '       ,   RLE -  
   BMPType  = 0   :    UseRLE  = 0
   UseAlpha = 0   :    UseMask = 0

  '     
   SELECT CASE Head2.BitDepth
       '___ 1 BIT ___
     CASE 1: BMPType = 1
       '___ 4 BIT ___
     CASE 4:
        '    
        IF Head2.Compress = 2 THEN
          BMPType = 9: UseRLE = -1   '  RLE
        ELSEIF Head2.Compress = 0 THEN
          BMPType = 2                '  
        END IF
        
       '___ 8 BIT ___
     CASE 8:
        '    
        IF Head2.Compress = 1 THEN
          BMPType = 10: UseRLE = -1  '  RLE
        ELSEIF Head2.Compress = 0 THEN
          BMPType = 3                '  
        END IF
       '___ 16 BIT ___
     CASE 16
        '     
        IF Head2.Compress = 3 THEN
          BMPType = 5: UseMask = -1  '  
        ELSEIF Head2.Compress = 0 THEN
          BMPType = 4                '  
        END IF

       '___ 24 BIT ___
     CASE 24: BMPType = 6
       '___ 32 BIT ___
     CASE 32 
        '     
        IF Head2.Compress = 3 THEN
          BMPType = 8: UseMask = -1  '  
        ELSEIF Head2.Compress = 0 THEN
          BMPType = 7                '  
        END IF
       '______________
   END SELECT

   '    4  8  -  
   SELECT CASE Head2.BitDepth
     CASE 4, 8
        '       16  256 
        MaxColors = Head2.UseColor
        IF Head2.SignColr > MaxColors THEN MaxColors = Head2.SignColr 
        '       -   
        IF MaxColors = 0 THEN MaxColors = ((Head1.BmOFFSET + 1) - (Head2.HeadSize + 15)) SHR 2

        SEEK #FrF, 15 + Head2.HeadSize
        FOR QPal AS INTEGER = 0 TO MaxColors - 1      '   
           GET #FrF, , GetByte: PalB(QPal) = GetByte
           GET #FrF, , GetByte: PalG(QPal) = GetByte
           GET #FrF, , GetByte: PalR(QPal) = GetByte
           GET #FrF, , GetByte: PalA(QPal) = GetByte
           Cv256(QPal) = RGB(PalR(QPal), PalG(QPal), PalB(QPal))
        NEXT
   END SELECT

  '       BMP,  
  IF BMPType = 0 THEN BMError = -1

  '     ,   
   IF UseMask THEN
     IF BMFLn > 70 THEN
       '   
        GET #FrF, SIZEOF(BMOne) + SIZEOF(BMTwo) + 1, BMask

       '        -   
       IF BMask.AlfM <> 0 THEN UseAlpha = -1

     MaskR = BMask.RedM                    '      
     MaskG = BMask.GrnM
     MaskB = BMask.BluM
     MaskA = BMask.AlfM

     '     
     SELECT CASE Head2.BitDepth
       CASE 16

        CalcMask  MaskR, RPosit, RShift, 3    '   
        CalcMask  MaskG, GPosit, GShift, 3
        CalcMask  MaskB, BPosit, BShift, 3

        '       16 
        IF UseAlpha THEN
          CalcMask  MaskA, APosit, AShift, 7
          '     (0-255)      BMP
          '  ..   1 ,    0
          DIM Stp AS DOUBLE, Delen AS INTEGER, NabVal AS DOUBLE
          DIM AlfMasPrep(MaskA) AS UBYTE

          Delen = 256 \ (MaskA + 1)
          Stp = 255 / MaskA

          FOR i AS INTEGER = 0 TO MaskA
             AlfMasPrep(i) = CINT(NabVal)
             NabVal = NabVal + Stp
          NEXT
          FOR i AS INTEGER = 0 TO 255
             CvAlf(i) = (AlfMasPrep(i \ Delen)) SHL 24
          NEXT
          '   
          ERASE AlfMasPrep

        END IF

        '        16    
        FOR i AS ULONG = 1 TO 65535
           R16 = (((i SHR RPosit) AND MaskR) SHL 16) SHL RShift
           G16 = (((i SHR GPosit) AND MaskG) SHL 8 ) SHL GShift
           B16 = (((i SHR BPosit) AND MaskB)       ) SHL BShift

           IF UseAlpha THEN
             A16 =  CvAlf(   ((i SHR APosit) AND MaskA) SHL AShift   )
           
             ELSE A16 = &HFF000000
           END IF

           Cv16Bit(i) = (R16 OR G16) + (B16 OR A16)
        NEXT

       CASE 32

        CalcMask32 MaskR, RPosit
        CalcMask32 MaskG, GPosit
        CalcMask32 MaskB, BPosit
        CalcMask32 MaskA, APosit

     END SELECT
     '   

     ELSE
       BMError = -1
     END IF
   END IF

  '    ,     
   IF BMError THEN CLOSE FrF : EXIT SUB

  '       
   DTLen = BMFLn - Head1.BmOFFSET
 

  '   -       
   IF DTLen <> Head2.DataSize THEN
     '    DataSize   
     IF Head2.DataSize = 0 THEN
       '     ,  ,  .
       IF Head1.BmOFFSET = 0 THEN
         CLOSE FrF : EXIT SUB
       END IF

     '    DataSize    
     ELSE
       '       
       CLOSE FrF : EXIT SUB
     END IF
   END IF

  '    ,  OK    , 
   IF ( NOT BMError ) AND ( DTLen > 0 ) THEN 
     '       
 
        '      
        '    SEEK   ,    
        '       
         SEEK #FrF, (Head1.BmOFFSET + 1)

       '      
         RAWMem = ALLOCATE(DTLen)

       '      
         BMPMem = ALLOCATE(BMSzX * BMSzY * 4)
         'BMPMem = ALLOCATE(BMSzX * BMSzY * 4, 1)

       '       
         GET #FrF, , *RAWMem, DTLen

    '     ..   
   CLOSE #FrF
    '    
   BMLoaded = -1

   ELSE
     '   ,    
     CLOSE #FrF
     EXIT SUB
   END IF 

 END SUB 

'
'         
'
 SUB ComputeAdressing ()

    DIM OneLine AS INTEGER
    DIM yp AS INTEGER

    DIM BytesInLine AS INTEGER
    DIM LongsInLine AS INTEGER
    
  '   Pitch   BMP
  SELECT CASE BMPType

    CASE 1    ' 1 BIT
      
      LongsInLine = (BMSzX + 31) SHR 5
      BmPitch = LongsInLine SHL 2

    CASE 2    ' 4 BIT

      LongsInLine = (BMSzX + 7) SHR 3
      BmPitch = LongsInLine SHL 2

    CASE 3    ' 8 BIT

      LongsInLine = (BMSzX + 3) SHR 2
      BmPitch = LongsInLine * 4

    CASE 4, 5 ' 16 BIT

      LongsInLine = (BMSzX + 1) SHR 1
      BmPitch = LongsInLine * 4

    CASE 6    ' 24 BIT

      BytesInLine = BMSzX * 3
      LongsInLine = BytesInLine SHR 2
      IF (BytesInLine AND 3) > 0 THEN LongsInLine += 1
      BmPitch = LongsInLine SHL 2

    CASE 7, 8 ' 32 BIT

      BmPitch = BMSzX * 4

  END SELECT

  '  RAWMem -     BMP  
  '  BMPMem -     32  
  '  Adr  -      (BMP )
     Adr = RAWMem

     OneLine = BMSzX * 4        '       

     '      Y  TakePix
     REDIM YMuls(BMSzY - 1)
     TableAdress = VARPTR(YMuls(0))
     '       Y
     '     
     REDIM YRevMuls(BMSzY - 1)
     '      Y 
     '    
     REDIM YInAdrs(BMSzY - 1)

     '   
     FOR yp = 0 TO BMSzY - 1
        '     
        YMuls(yp) = BMPMem + (yp * OneLine)
        YRevMuls((BMSzY - 1) - yp) = YMuls(yp)
        '     
        YInAdrs(yp) = Adr
        Adr += BmPitch
     NEXT

 END SUB

'
'          BMP 
'
 SUB CnvLine (InpAdrs AS BYTE PTR, OutAdrs AS BYTE PTR)
  DIM ix AS INTEGER
  DIM AdrFrom AS BYTE PTR = InpAdrs, AdrTo AS BYTE PTR = OutAdrs
  DIM Cv AS ULONG

  '   1 
  DIM OneByte AS UBYTE, BitNum AS INTEGER, GetBit AS INTEGER
  DIM NeedRead AS INTEGER
  '   4 
  DIM FirstHalf AS INTEGER
  '   16 
  DIM Cv16 AS USHORT
  '   32 
  DIM RCmp AS UBYTE, GCmp AS UBYTE, BCmp AS UBYTE, ACmp AS UBYTE


   '     BMP
   SELECT CASE BMPType
   CASE 1  ' 1 BIT  

   #IFNDEF BMPASM
    NeedRead = -1
    BitNum = 0
    FOR ix = 0 TO BMSzX - 1
       IF NeedRead THEN
         OneByte = PEEK(AdrFrom)
         AdrFrom += 1
         NeedRead = 0
       END IF
       SELECT CASE BitNum
         CASE 0: GetBit = OneByte SHR 7 AND 1
         CASE 1: GetBit = OneByte SHR 6 AND 1
         CASE 2: GetBit = OneByte SHR 5 AND 1
         CASE 3: GetBit = OneByte SHR 4 AND 1
         CASE 4: GetBit = OneByte SHR 3 AND 1
         CASE 5: GetBit = OneByte SHR 2 AND 1
         CASE 6: GetBit = OneByte SHR 1 AND 1
         CASE 7: GetBit = OneByte AND 1: NeedRead = -1
       END SELECT

       POKE ULONG, AdrTo, Cv1Bit(GetBit)
       AdrTo += 4
       BitNum = (BitNum + 1) AND 7
    NEXT ix

   #ELSE
    '   x32-
    #IFNDEF __FB_64BIT__
      ASM
        MOV esi, [InpAdrs]          '   
        MOV edi, [OutAdrs]          '   
        MOV ecx, [BMSzX]            '   
        XOR ebx, ebx
        CLD
        Type1Ck:
          '   Ebx  
          OR bx, bx
          JNZ NoLd1
          '   Ebx = 0   
          '     al
          XOR eax, eax

          LODSB
          '      dl
          MOV dl, al

        NoLd1:
          '      dl
          MOV al, dl
          '    
          AND al, &B10000000
          '     
          SHR al, 7
          '    ,      
          JNZ ToSet1
            '     
            MOV eax, &HFF000000
            JMP ToClr1 
          ToSet1:
            MOV eax, &HFFFFFFFF
          ToClr1:

          '     ,     
          ROL dl
      
          '    
          INC bx
          AND bx, 7

          '   4 
          STOSD
        '    
        DEC ecx
        JNZ Type1Ck
     
      END ASM
    '   x64-
    #ELSE
      ASM
        MOV rsi, InpAdrs          '   
        MOV rdi, OutAdrs          '   
        MOV ecx, BMSzX          '   
'        DEC ecx
        XOR ebx, ebx
        CLD
        Type1Ck:
          '   Ebx  
          OR bx, bx
          JNZ NoLd1
          '   Ebx = 0   
          '     al
          XOR eax, eax

          LODSB
          '      dl
          MOV dl, al
        NoLd1:
          '      dl
          MOV al, dl
          '    
          'AND al, &B10000000

          '     
          SHR al, 7
          '    ,      
          JNZ ToSet1
            '     
            MOV eax, &HFF000000
            JMP ToClr1 
          ToSet1:
            MOV eax, &HFFFFFFFF
          ToClr1:

          '     ,     
          ROL dl
      
          '    
          INC bx
          AND bx, 7

          '   4 
          STOSD
          'SUB RDI, 4
        '    
        DEC Rcx
        JNZ Type1Ck
     
      END ASM

    #ENDIF
   #ENDIF

   CASE 2  ' 4 BIT  

    FirstHalf = 0
    '       X
    FOR ix = 0 TO BMSzX - 1

       '   1      (  4 )
       IF FirstHalf = 0 THEN
         OneByte = PEEK(UBYTE, AdrFrom)
         AdrFrom += 1
         Cv = Cv256(OneByte SHR 4)
       ELSE
         Cv = Cv256(OneByte AND 15)
       END IF
       
       POKE ULONG, AdrTo, Cv
       FirstHalf = 1 - FirstHalf
       AdrTo += 4
    NEXT

   CASE 3  ' 8 BIT  

    '       X
    FOR ix = 0 TO BMSzX - 1
       '   
       Cv = PEEK(UBYTE, AdrFrom)
       POKE ULONG, AdrTo, Cv256(Cv)
       AdrFrom += 1
       AdrTo += 4
    NEXT

   CASE 4  ' 16 BIT (std)


     #IFNDEF BMPASM
     FOR ix = 0 TO BMSzX - 1
        Cv16 = PEEK(USHORT, AdrFrom)
        Cv = ((Cv16 AND &H1F) SHL 3) OR ((Cv16 AND &H3E0) SHL 6) OR ((Cv16 AND &H7C00) SHL 9) OR &HFF000000

        POKE ULONG, AdrTo, Cv

        AdrFrom += 2
        AdrTo += 4
     NEXT
     #ELSE     
        '  x32
        #IFNDEF __FB_64BIT__
         ASM
            XOR eax, eax
            MOV esi, [AdrFrom]              '       (16 )
            MOV ecx, BMSzX
            MOV edi, [AdrTo]                '       (32 )

            MOV edx, &HFF000000             '     Alf- ( .)
         b16Lp:
            MOV eax, edx                    '    3-  EAX    255
            LODSW                           '   AX = 16 Bit Col RRRRRGGG GGGBBBBB
            MOV ebx, eax                    '   BX = AX         RRRRRGGG GGGBBBBB
            SHL ax, 3                       '   AX =            RRRGGGGG BBBBBooo
            SHL ebx, 9                      '   EBX =  RRRRRGGG GGBBBBBo 00000000
            SHL ah, 3                       '   AX =            GGGGGooo BBBBBooo
            AND ebx,  &HF80000              '   EBX =  RRRRRooo 00000000 00000000
            OR  eax, ebx                    '   EAX =  RRRRRooo GGGGGooo BBBBBooo
            STOSD                           '     (32 )
            DEC ecx
            JNZ b16Lp
         END ASM
        '  x64
        #ELSE
         ASM
            XOR eax, eax
            MOV rsi, [AdrFrom]              '       (16 )
            MOV ecx, BMSzX
            MOV rdi, [AdrTo]                '       (32 )

            MOV edx, &HFF000000             '     Alf- ( .)
         b16Lp2:
            MOV eax, edx                    '    3-  EAX    255
            LODSW                           '   AX = 16 Bit Col RRRRRGGG GGGBBBBB
            MOV ebx, eax                    '   BX = AX         RRRRRGGG GGGBBBBB
            SHL ax, 3                       '   AX =            RRRGGGGG BBBBBooo
            SHL ebx, 9                      '   EBX =  RRRRRGGG GGBBBBBo 00000000
            SHL ah, 3                       '   AX =            GGGGGooo BBBBBooo
            AND ebx,  &HF80000              '   EBX =  RRRRRooo 00000000 00000000
            OR  eax, ebx                    '   EAX =  RRRRRooo GGGGGooo BBBBBooo
            STOSD                           '     (32 )
            DEC ecx
            JNZ b16Lp2
         END ASM
        #ENDIF
     #ENDIF

   CASE 5  ' 16 BIT + Mask

     FOR ix = 0 TO BMSzX - 1
         Cv16 = PEEK(USHORT, AdrFrom)
         POKE ULONG, AdrTo, Cv16Bit(Cv16)

         AdrFrom += 2
         AdrTo += 4
     NEXT

   CASE 6  ' 24 BIT  

     FOR ix = 0 TO BMSzX - 1
         Cv = PEEK(ULONG, AdrFrom) OR &HFF000000
         POKE ULONG, AdrTo, Cv

         AdrFrom += 3
         AdrTo += 4
     NEXT

   CASE 7  ' 32 BIT (std)

     FOR ix = 0 TO BMSzX - 1
         Cv = PEEK(ULONG, AdrFrom)
         POKE ULONG, AdrTo, Cv

         AdrFrom += 4
         AdrTo += 4
     NEXT

   CASE 8  ' 32 BIT + Mask
                    
   IF UseAlpha THEN

     '       X
     FOR ix = 0 TO BMSzX - 1

        '   
        RCmp = PEEK(UBYTE, AdrFrom + RPosit)
        GCmp = PEEK(UBYTE, AdrFrom + GPosit)
        BCmp = PEEK(UBYTE, AdrFrom + BPosit)
        ACmp = PEEK(UBYTE, AdrFrom + APosit)

        '    
        POKE ULONG, AdrTo, RGBA(RCmp, GCmp, BCmp, ACmp)
        AdrFrom += 4
        AdrTo += 4
     NEXT

   ELSE

     FOR ix = 0 TO BMSzX - 1

        '   
        RCmp = PEEK(UBYTE, AdrFrom + RPosit)
        GCmp = PEEK(UBYTE, AdrFrom + GPosit)
        BCmp = PEEK(UBYTE, AdrFrom + BPosit)

        '    
        POKE ULONG, AdrTo, RGB(RCmp, GCmp, BCmp)
        AdrFrom += 4
        AdrTo += 4
     NEXT
   END IF

   END SELECT

 END SUB

'
'       BMP  32   
'
 SUB ConvertLines ()
  DIM iy AS INTEGER
  DIM InAdr AS ANY PTR
  DIM OuAdr AS ANY PTR
  
  '     
    FOR iy = 0 TO BMSzY - 1
       '     
       InAdr = YInAdrs(iy)
       '     
       OuAdr = YRevMuls(iy)

          '   
          CnvLine  InAdr, OuAdr

    NEXT

 END SUB

'
'     *.BMP*
'
 SUB Load (FName AS STRING)

   DetectType  FName          '   
    
    IF BMLoaded THEN

      ComputeAdressing ()     '     
      ConvertLines ()         '   

      DEALLOCATE  RAWMem      '    
    END IF
    
 END SUB
 
'
'       FBGfx Image
'
 FUNCTION ToGfxImg () AS BYTE PTR

  DIM  Adr AS BYTE PTR, Adr2 AS BYTE PTR, AdrGfx AS BYTE PTR
  DIM  NewGfxImg AS BYTE PTR = IMAGECREATE (BMSzX, BMSzY, , 32)
  DIM  GfxPitch AS INTEGER, Cv  AS ULONG
  DIM  GfxWidth AS INTEGER, GfxHeight AS INTEGER, GfxBPP AS INTEGER
  
  IF IMAGEINFO(NewGfxImg, GfxWidth, GfxHeight, GfxBPP, GfxPitch, AdrGfx) = 0 THEN
  
    FOR iy AS INTEGER = 0 TO BMP.BMSzY - 1
       Adr  = YMuls(iy)
       Adr2 = AdrGfx
       AdrGfx += GfxPitch
       FOR ix AS INTEGER = 0 TO BMP.BMSzX - 1
          Cv = PEEK(ULONG, Adr)     '   
          POKE ULONG, Adr2, Cv      '    
          Adr += 4
          Adr2 += 4
       NEXT ix
    NEXT iy

    ToGfxImg = NewGfxImg
  ELSE
    ToGfxImg = 0
  END IF

 END FUNCTION


'
'        FBGfx Image
'
 FUNCTION LoadToGfx (FName AS STRING) AS ANY PTR

   Load (FName)
   LoadToGfx = ToGfxImg()

 END FUNCTION

'
'       FBGfx Image
'
 FUNCTION CheckerToGfx (ChSizeX AS INTEGER, ChSizeY AS INTEGER) AS ANY PTR
   DIM  Cv AS ULONG
   DIM  NewGfxImg AS BYTE PTR = IMAGECREATE (ChSizeX, ChSizeY, , 32)
   FOR iy AS INTEGER = 0 TO ChSizeY - 1
      FOR ix AS INTEGER = 0 TO ChSizeX - 1
         Cv = &HFF6E6E6E
         IF (ix SHR 4 AND 1) XOR (iy SHR 4 AND 1) THEN Cv += &H2D2D2D
         PSET NewGfxImg, (ix, iy), Cv
   NEXT ix, iy
   CheckerToGfx = NewGfxImg
 END FUNCTION

'
'          *.BMP*
'
 SUB TakePix (x AS INTEGER, y AS INTEGER)
     
    PixCV = PEEK (ULONG, (x SHL 2 + YMuls(y) ) )
     
 END SUB

'
'        
'
 FUNCTION TakePointer () AS ANY PTR
     
    TakePointer = BMPMem
     
 END FUNCTION

'
'          *.BMP*
'
 #IFNDEF BMPASM

 SUB TakePixClip (x AS ULONG, y AS ULONG)
    IF x < BMSzX ANDALSO y < BMSzY THEN
      PixCV = PEEK (ULONG, (x SHL 2 + YMuls(y) ) )
    ELSE
      PixCV = 0
    END IF
 END SUB

 #ELSE

 SUB TakePixClip NAKED (x AS ULONG, y AS ULONG)
    '   x32-
    #IFNDEF __FB_64BIT__

     ASM
      '  ESP + 4 -   (ECX) .  x
      '  ESP + 8 -   (EDX) .  y
       MOV edx, DWORD PTR [esp + 8]
       '   
       CMP edx, BMSzY
       JAE PixClip

       MOV ecx, DWORD PTR [esp + 4]
       CMP ecx, BMSzX
       JAE PixClip

       'CLD

       SHL ecx, 2        '  x = x * 4
       SHL edx, 2        '  y = y * 8      64  - 8 

       MOV ebx, TableAdress         '  RBX =   YMuls
       ADD ebx, edx                 '   Y,  YMuls(y)
       MOV esi, DWORD PTR[ebx]      '    YMuls 

       ADD esi, ecx                 '   X * 2      YMuls(y)
       
       '    ESI
       LODSD                        '  EAX =        
       MOV PixCV, eax
       RET

       PixClip: 
       XOR eax, eax
       MOV PixCV, eax
       
       RET
     END ASM

    '   x64-
    #ELSE
      '  RCX -   .  x
      '  RDX -   .  y
     ASM

       '   
       CMP edx, BMSzY
       JAE PixClip

       CMP ecx, BMSzX
       JAE PixClip

       'CLD

       SHL ecx, 2        '  x = x * 4
       SHL edx, 3        '  y = y * 8      64  - 8 

       MOV rbx, TableAdress         '  RBX =   YMuls
       ADD rbx, rdx                 '   Y,  YMuls(y)
       MOV rsi, QWORD PTR[rbx]      '    YMuls 

       ADD rsi, rcx                 '   X * 2      YMuls(y)
       
       '    RSI
       LODSD                        '  EAX =        
       MOV PixCV, eax
       RET

       PixClip: 
       XOR eax, eax
       MOV PixCV, eax
       
       RET
     END ASM

    #ENDIF
 END SUB

 #ENDIF


 SUB PrintInfo (x AS ULONG, y AS ULONG)
    DRAW STRING (x, y),       "BMP Type : " + STR(BMPType), &HFFFFFFFF
    DRAW STRING STEP (0, 10), "Res X * Y: " + STR(BMSzX) + " x " + STR(BMSzY), &HFFFFFFFF
    DRAW STRING STEP (0, 10), "UseAlpha : " + STR(UseAlpha), &HFFFFFFFF
    DRAW STRING STEP (0, 10), "UseAlpha : " + STR(UseAlpha), &HFFFFFFFF
 END SUB
'
'    *.BMP*  .
'

 SUB ClosePic ()
    IF BMLoaded = 0 THEN EXIT SUB
    DEALLOCATE (BMPMem)
    BMPMem = 0
    BMLoaded = 0
 END SUB
 
 END NAMESPACE
